/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.treefeature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RegionsUnexploredBlocks;
import net.regions_unexplored.data.tags.RegionsUnexploredTags;

public class NetherWillowFeature
extends Feature<NoneFeatureConfiguration> {
    public NetherWillowFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        int height = context.m_225041_().m_188503_(3) + 8;
        if (level.m_8055_(pos.m_7495_()).m_60734_() != Blocks.f_50440_) {
            return false;
        }
        if (level.m_46859_(pos) && !level.m_46859_(pos.m_7495_())) {
            BlockPos.MutableBlockPos placePos = pos.m_122032_();
            for (int i = 0; i <= height; ++i) {
                if (level.m_151570_((BlockPos)placePos)) {
                    return true;
                }
                if (i == 0) {
                    level.m_7731_(placePos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
                }
                if (i == 1) {
                    this.placeRoots((LevelAccessor)level, (BlockPos)placePos);
                }
                if (i == height - 3) {
                    this.placeBranches((LevelAccessor)level, (BlockPos)placePos);
                }
                if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, (BlockPos)placePos)) {
                    level.m_7731_((BlockPos)placePos, Blocks.f_49999_.m_49966_(), 2);
                }
                if (i == height) {
                    this.placeLeavesNoVine((LevelAccessor)level, (BlockPos)placePos);
                }
                placePos.m_122173_(Direction.UP);
            }
            return true;
        }
        return false;
    }

    private void placeBranches(LevelAccessor level, BlockPos pos) {
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_())) {
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_())) {
                level.m_7731_(pos.m_122012_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_7494_().m_122012_())) {
                level.m_7731_(pos.m_122012_().m_7494_().m_122012_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_7494_().m_122012_().m_122012_())) {
                level.m_7731_(pos.m_122012_().m_7494_().m_122012_().m_122012_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_7494_().m_122012_().m_122012_().m_122012_())) {
                level.m_7731_(pos.m_122012_().m_7494_().m_122012_().m_122012_().m_122012_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
                this.placeLeaves(level, pos.m_122012_().m_7494_().m_122012_().m_122012_().m_122012_());
            }
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_())) {
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_())) {
                level.m_7731_(pos.m_122019_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_7494_().m_122019_())) {
                level.m_7731_(pos.m_122019_().m_7494_().m_122019_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_7494_().m_122019_().m_122019_())) {
                level.m_7731_(pos.m_122019_().m_7494_().m_122019_().m_122019_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_7494_().m_122019_().m_122019_().m_122019_())) {
                level.m_7731_(pos.m_122019_().m_7494_().m_122019_().m_122019_().m_122019_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
                this.placeLeaves(level, pos.m_122019_().m_7494_().m_122019_().m_122019_().m_122019_());
            }
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_())) {
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_())) {
                level.m_7731_(pos.m_122029_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_().m_7494_().m_122029_())) {
                level.m_7731_(pos.m_122029_().m_7494_().m_122029_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_().m_7494_().m_122029_().m_122029_())) {
                level.m_7731_(pos.m_122029_().m_7494_().m_122029_().m_122029_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_().m_7494_().m_122029_().m_122029_().m_122029_())) {
                level.m_7731_(pos.m_122029_().m_7494_().m_122029_().m_122029_().m_122029_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
                this.placeLeaves(level, pos.m_122029_().m_7494_().m_122029_().m_122029_().m_122029_());
            }
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_())) {
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_())) {
                level.m_7731_(pos.m_122024_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_().m_7494_().m_122024_())) {
                level.m_7731_(pos.m_122024_().m_7494_().m_122024_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_().m_7494_().m_122024_().m_122024_())) {
                level.m_7731_(pos.m_122024_().m_7494_().m_122024_().m_122024_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_().m_7494_().m_122024_().m_122024_().m_122024_())) {
                level.m_7731_(pos.m_122024_().m_7494_().m_122024_().m_122024_().m_122024_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
                this.placeLeaves(level, pos.m_122024_().m_7494_().m_122024_().m_122024_().m_122024_());
            }
        }
    }

    private void placeRoots(LevelAccessor level, BlockPos pos) {
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_())) {
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_())) {
                level.m_7731_(pos.m_122012_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_7495_().m_122012_())) {
                level.m_7731_(pos.m_122012_().m_7495_().m_122012_(), Blocks.f_49999_.m_49966_(), 2);
                if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_7495_().m_122012_().m_7495_())) {
                    level.m_7731_(pos.m_122012_().m_7495_().m_122012_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                    if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_7495_().m_122012_().m_7495_().m_7495_())) {
                        level.m_7731_(pos.m_122012_().m_7495_().m_122012_().m_7495_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_7495_().m_122012_().m_7495_().m_7495_().m_7495_())) {
                            level.m_7731_(pos.m_122012_().m_7495_().m_122012_().m_7495_().m_7495_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                        }
                    }
                }
            }
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_())) {
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_())) {
                level.m_7731_(pos.m_122019_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_7495_().m_122019_())) {
                level.m_7731_(pos.m_122019_().m_7495_().m_122019_(), Blocks.f_49999_.m_49966_(), 2);
                if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_7495_().m_122019_().m_7495_())) {
                    level.m_7731_(pos.m_122019_().m_7495_().m_122019_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                    if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_7495_().m_122019_().m_7495_().m_7495_())) {
                        level.m_7731_(pos.m_122019_().m_7495_().m_122019_().m_7495_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_7495_().m_122019_().m_7495_().m_7495_().m_7495_())) {
                            level.m_7731_(pos.m_122019_().m_7495_().m_122019_().m_7495_().m_7495_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                        }
                    }
                }
            }
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_())) {
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_())) {
                level.m_7731_(pos.m_122029_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_().m_7495_().m_122029_())) {
                level.m_7731_(pos.m_122029_().m_7495_().m_122029_(), Blocks.f_49999_.m_49966_(), 2);
                if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_().m_7495_().m_122029_().m_7495_())) {
                    level.m_7731_(pos.m_122029_().m_7495_().m_122029_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                    if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_().m_7495_().m_122029_().m_7495_().m_7495_())) {
                        level.m_7731_(pos.m_122029_().m_7495_().m_122029_().m_7495_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_().m_7495_().m_122029_().m_7495_().m_7495_().m_7495_())) {
                            level.m_7731_(pos.m_122029_().m_7495_().m_122029_().m_7495_().m_7495_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                        }
                    }
                }
            }
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_())) {
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_())) {
                level.m_7731_(pos.m_122024_(), (BlockState)Blocks.f_49999_.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), 2);
            }
            if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_().m_7495_().m_122024_())) {
                level.m_7731_(pos.m_122024_().m_7495_().m_122024_(), Blocks.f_49999_.m_49966_(), 2);
                if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_().m_7495_().m_122024_().m_7495_())) {
                    level.m_7731_(pos.m_122024_().m_7495_().m_122024_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                    if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_().m_7495_().m_122024_().m_7495_().m_7495_())) {
                        level.m_7731_(pos.m_122024_().m_7495_().m_122024_().m_7495_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_().m_7495_().m_122024_().m_7495_().m_7495_().m_7495_())) {
                            level.m_7731_(pos.m_122024_().m_7495_().m_122024_().m_7495_().m_7495_().m_7495_(), Blocks.f_49999_.m_49966_(), 2);
                        }
                    }
                }
            }
        }
    }

    private void placeLeaves(LevelAccessor level, BlockPos pos) {
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7494_())) {
            level.m_7731_(pos.m_7494_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7494_().m_122012_())) {
            level.m_7731_(pos.m_7494_().m_122012_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7494_().m_122012_().m_122029_())) {
            level.m_7731_(pos.m_7494_().m_122012_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7494_().m_122012_().m_122024_())) {
            level.m_7731_(pos.m_7494_().m_122012_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7494_().m_122019_())) {
            level.m_7731_(pos.m_7494_().m_122019_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7494_().m_122019_().m_122029_())) {
            level.m_7731_(pos.m_7494_().m_122019_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7494_().m_122019_().m_122024_())) {
            level.m_7731_(pos.m_7494_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7494_().m_122029_())) {
            level.m_7731_(pos.m_7494_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_7494_().m_122024_())) {
            level.m_7731_(pos.m_7494_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_())) {
            level.m_7731_(pos.m_122012_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_122012_())) {
            level.m_7731_(pos.m_122012_().m_122012_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122012_().m_122012_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_122024_())) {
            level.m_7731_(pos.m_122012_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_122012_().m_122024_())) {
            level.m_7731_(pos.m_122012_().m_122012_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122012_().m_122012_().m_122024_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_122024_().m_122024_())) {
            level.m_7731_(pos.m_122012_().m_122024_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122012_().m_122024_().m_122024_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_())) {
            level.m_7731_(pos.m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122024_().m_122024_())) {
            level.m_7731_(pos.m_122024_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122024_().m_122024_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_122024_())) {
            level.m_7731_(pos.m_122019_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_122019_().m_122024_())) {
            level.m_7731_(pos.m_122019_().m_122019_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122019_().m_122019_().m_122024_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_122024_().m_122024_())) {
            level.m_7731_(pos.m_122019_().m_122024_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122019_().m_122024_().m_122024_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_())) {
            level.m_7731_(pos.m_122019_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_122019_())) {
            level.m_7731_(pos.m_122019_().m_122019_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122019_().m_122019_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_122029_())) {
            level.m_7731_(pos.m_122019_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_122019_().m_122029_())) {
            level.m_7731_(pos.m_122019_().m_122019_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122019_().m_122019_().m_122029_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122019_().m_122029_().m_122029_())) {
            level.m_7731_(pos.m_122019_().m_122029_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122019_().m_122029_().m_122029_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_())) {
            level.m_7731_(pos.m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122029_().m_122029_())) {
            level.m_7731_(pos.m_122029_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122029_().m_122029_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_122029_())) {
            level.m_7731_(pos.m_122012_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_122012_().m_122029_())) {
            level.m_7731_(pos.m_122012_().m_122012_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122012_().m_122012_().m_122029_());
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.m_122012_().m_122029_().m_122029_())) {
            level.m_7731_(pos.m_122012_().m_122029_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            this.addVine(level, pos.m_122012_().m_122029_().m_122029_());
        }
    }

    private void placeLeavesNoVine(LevelAccessor level, BlockPos blockPos) {
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos)) {
            level.m_7731_(blockPos, (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_7494_())) {
            level.m_7731_(blockPos.m_7494_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_7494_().m_122012_())) {
            level.m_7731_(blockPos.m_7494_().m_122012_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_7494_().m_122012_().m_122029_())) {
            level.m_7731_(blockPos.m_7494_().m_122012_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_7494_().m_122012_().m_122024_())) {
            level.m_7731_(blockPos.m_7494_().m_122012_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_7494_().m_122019_())) {
            level.m_7731_(blockPos.m_7494_().m_122019_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_7494_().m_122019_().m_122029_())) {
            level.m_7731_(blockPos.m_7494_().m_122019_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_7494_().m_122019_().m_122024_())) {
            level.m_7731_(blockPos.m_7494_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_7494_().m_122029_())) {
            level.m_7731_(blockPos.m_7494_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_7494_().m_122024_())) {
            level.m_7731_(blockPos.m_7494_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122012_())) {
            level.m_7731_(blockPos.m_122012_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122012_().m_122012_())) {
            level.m_7731_(blockPos.m_122012_().m_122012_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122012_().m_122024_())) {
            level.m_7731_(blockPos.m_122012_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122012_().m_122012_().m_122024_())) {
            level.m_7731_(blockPos.m_122012_().m_122012_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122012_().m_122024_().m_122024_())) {
            level.m_7731_(blockPos.m_122012_().m_122024_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122024_())) {
            level.m_7731_(blockPos.m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122024_().m_122024_())) {
            level.m_7731_(blockPos.m_122024_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122019_().m_122024_())) {
            level.m_7731_(blockPos.m_122019_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122019_().m_122019_().m_122024_())) {
            level.m_7731_(blockPos.m_122019_().m_122019_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122019_().m_122024_().m_122024_())) {
            level.m_7731_(blockPos.m_122019_().m_122024_().m_122024_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122019_())) {
            level.m_7731_(blockPos.m_122019_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122019_().m_122019_())) {
            level.m_7731_(blockPos.m_122019_().m_122019_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122019_().m_122029_())) {
            level.m_7731_(blockPos.m_122019_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122019_().m_122019_().m_122029_())) {
            level.m_7731_(blockPos.m_122019_().m_122019_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122019_().m_122029_().m_122029_())) {
            level.m_7731_(blockPos.m_122019_().m_122029_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122029_())) {
            level.m_7731_(blockPos.m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122029_().m_122029_())) {
            level.m_7731_(blockPos.m_122029_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122012_().m_122029_())) {
            level.m_7731_(blockPos.m_122012_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122012_().m_122012_().m_122029_())) {
            level.m_7731_(blockPos.m_122012_().m_122012_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (NetherWillowFeature.isReplaceable((LevelSimulatedReader)level, blockPos.m_122012_().m_122029_().m_122029_())) {
            level.m_7731_(blockPos.m_122012_().m_122029_().m_122029_(), (BlockState)Blocks.f_50050_.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    private void addVine(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        int size = random.nextInt(3);
        BlockPos place = pos.m_7495_();
        for (int i = 0; i <= size; ++i) {
            if (NetherWillowFeature.isAir((LevelSimulatedReader)level, place)) {
                if (i == size) {
                    level.m_7731_(place, ((Block)RegionsUnexploredBlocks.SPANISH_MOSS.get()).m_49966_(), 2);
                } else {
                    level.m_7731_(place, ((Block)RegionsUnexploredBlocks.SPANISH_MOSS_PLANT.get()).m_49966_(), 2);
                }
            } else {
                if (i == 0) break;
                level.m_7731_(place.m_7494_(), ((Block)RegionsUnexploredBlocks.SPANISH_MOSS.get()).m_49966_(), 2);
                break;
            }
            place = place.m_7495_();
        }
    }

    public static boolean isAirBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50016_) || state.m_60713_(Blocks.f_50627_) || state.m_60713_(Blocks.f_50626_);
    }

    public static boolean isAir(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, NetherWillowFeature::isAirBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RegionsUnexploredTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, NetherWillowFeature::isReplaceableBlock);
    }
}

